/*  Errechnet die geplante Arbeitszeit für eine gegebene Kostenstelle im vorgegebenen Zeitfenster.

    Sind keine Task-Blöcke für die Kombination aus gegebener Kostenstelle und Zeitraum in der Tabelle resource_timeline eingetragen,
    gibt die Funktion NULL zurück.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__ksv_shorthand__get_scheduled_time', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__ksv_shorthand__get_scheduled_time(
    _ksv_shorthand    varchar,
    _timeframe_start  timestamp                                 DEFAULT '-infinity',
    _timeframe_end    timestamp                                 DEFAULT  'infinity',
    _ti_types         scheduling.resource_timeline_blocktype[]  DEFAULT ARRAY[ 'task', 'task.buffer' ]::scheduling.resource_timeline_blocktype[]
) RETURNS numeric AS $$

    SELECT
        sum(
            extract( epoch FROM ti_date_end - ti_date_start )
          * ti_ta_kf
        )::numeric
    FROM scheduling.resource_timeline
    WHERE
          ti_type = ANY( _ti_types )
      AND ti_resource_id = scheduling.resource__translate__ksvba__shorthand__to__resource_id( _ksv_shorthand )
      AND ti_date_end <= _timeframe_end
      AND ti_date_start >= _timeframe_start

$$ LANGUAGE sql;